{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 09.03.98 - 20:49:35 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMCstDlg, MMACMDlg, StdCtrls, MMGauge, MMACMCvt, MMHook, MMDesign,
  MMWave, MMDSPObj, MMTrigg, MMSystem;

type
  TForm1 = class(TForm)
    Trigger: TMMTrigger;
    SrcFile: TMMWaveFile;
    MMDesigner1: TMMDesigner;
    DstFile: TMMWaveFile;
    btnStart: TButton;
    btnStop: TButton;
    Gauge: TMMGauge;
    ListBox: TListBox;
    btnFile: TButton;
    ACM: TMMACM;
    WaveOpenDialog: TMMWaveOpenDialog;
    PCMConverter: TMMPCMConverter;
    procedure btnFileClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure TriggerOpen(Sender: TObject);
    procedure TriggerClose(Sender: TObject);
    procedure TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure TriggerStop(Sender: TObject);
    procedure DstFileClose(Sender: TObject);
  public
    FileIndex: integer;
    Stopping : Boolean;
    procedure ConvertFile(Index: integer);
    procedure ShowProgress;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   // Close the form only if we not converting !
   CanClose := (trClose in Trigger.State);
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnFileClick(Sender: TObject);
var
   i: integer;
begin
   if WaveOpenDialog.Execute then
   begin
      for i := 0 to WaveOpenDialog.Files.Count-1 do
      begin
         ListBox.Items.Add(WaveOpenDialog.Files[i]);
      end;
      btnStart.Enabled := True;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStartClick(Sender: TObject);
begin
   FileIndex := 0;
   Stopping  := False;
   ConvertFile(FileIndex);
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   Stopping := True;
   Trigger.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.ConvertFile(index: integer);
var
   Ext,FName: string;

begin
   try
      ListBox.ItemIndex := index;

      FName := ListBox.Items[FileIndex];

      // load the source file
      SrcFile.Wave.FileName := FName;

      // build a unique FileName for destination: "FName_acm.wav"
      Ext := ExtractFileExt(FName);
      FName := Copy(FName,1,Pos(Ext,FName)-1)+'_pcx'+Ext;

      // delete the DestFile
      DeleteFile(FName);

      // set the Destinantion filename
      DstFile.Wave.FileName := FName;

      // start the conversion
      Trigger.Start;
   except
      Stopping := True;
      Trigger.Stop;
      raise;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerOpen(Sender: TObject);
begin
   // converting started so we adjust some controls
   Gauge.Visible := True;
   btnStart.Enabled := False;
   btnStop.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerStop(Sender: TObject);
begin
   // the file was done so we can close the trigger to prepare for the next file
   Trigger.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerClose(Sender: TObject);
begin
   // Trigger has closed so we can prepare the next file
   inc(FileIndex);
   if not Stopping and (FileIndex < ListBox.Items.Count) then
   begin
      // convert the next file
      ConvertFile(FileIndex);
   end
   else
   begin
      Gauge.Visible := False;
      btnStart.Enabled := True;
      btnStop.Enabled := False;

      if not Stopping then
         MessageDlg('Batch conversion done.',mtInformation,[mbOK], 0);
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.ShowProgress;
begin
   Gauge.Progress := Trunc((SrcFile.Wave.Position * 100)/SrcFile.Wave.DataSize);
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   // this event occurs in a different thread so we must snchronize to the VCL
   Trigger.SynchronizeVCL(ShowProgress);
end;

{------------------------------------------------------------------------------}
procedure TForm1.DstFileClose(Sender: TObject);
begin
   if (trPlay in Trigger.State) then
   begin
      Stopping := True;
      Trigger.Stop;
      MessageDlg('Can''t write to file, disk full ?',mtError,[mbOK], 0);
   end;
end;

end.
